-- Functions for Controller Access, MacroScript File
--
-- Created:  		May 17 2000
-- Last Updated: 	Jan 20 2006
--
-- Author :   Frank DeLise
-- Version:  3D Studio Max Version 4.0
--
--  Michael Zyracki updated on Jan 20th 2006 to add support for Layer Controllers.
-- Functions for accessing Controllers
--***********************************************************************************************
-- MODIFY THIS AT YOUR OWN RISK
-- Removed IsPosXYZ() filters, moved them into FilterFunctions.ms
-- Removed Prompting to the listner window Aug 15, 2000 -FD
-- Updated Target additions for the new constraint function publishing October 6 2000
-- Jan 4 Added support for HI and HD IK
fn IsLayerControl ctrl = 
(
	local result = false
	if classof ctrl == Position_Layer do
		result = true
	if classof ctrl == Rotation_Layer do
		result = true
	if classof ctrl == Point3_Layer do
		result = true
	if classof ctrl == Point4_Layer do
		result = true
	if classof ctrl == Scale_Layer do
		result = true
	if classof ctrl == Float_Layer do
		result = true

	result
)

fn AddListController OBJ Trans ListType = 
(
	Try
	(
		local xformC
		-------------------------------------------------------------------------------------------
		-- If object has IK assigned apply to subController, if it's an IK goal apply to Ik goal  if not, apply to controller
		-------------------------------------------------------------------------------------------
		if classof OBJ.controller == IKControl then  xformC = OBJ.controller.fk_sub_control.controller
			else if classof OBJ.controller == IKChainControl then  xformC = OBJ.controller.IK_goal.controller
				else xformC = OBJ.controller
		
		if classof xformC == IK_ControllerMatrix3Controller do
		(	if (substring (Trans as string) 1 3) as name == #pos then Trans = getsubanimname xformC 1
			else if (substring (Trans as string) 1 3) as name == #rot then Trans = getsubanimname xformC 2
		)

		if classof xformC == Link_Constraint do xformC = xformC.link_params
		if classof xformC == Link_Transform do xformC = xformC.Scene_Transform

		local oldC = getPropertyController xformC trans
		if classof oldC != ListType then
		(	local newC = execute (ListType as string + "()")
			if(IsLayerControl oldC) then
			(
				oldC[oldC.active].controller = newC
			 
			)else
			(
			  if (setPropertyController xformC trans newC) == undefined do throw 0
			)
			newC
		)
		else
			oldC
	)
	Catch (MessageBox ~MSGBOX_LIST_CONTROLLER_ERROR~ Title:~CONTROLLER_FUNCTIONS_TITLE~;throw())
) 

fn AddConstraint OBJ Trans Constraint List =
(
	Try
	(	
		local xformC
		-------------------------------------------------------------------------------------------
		-- If object has IK assigned apply to subController, if not, apply to controller
		-------------------------------------------------------------------------------------------
		if classof OBJ.controller == IKControl then xformC = OBJ.controller.fk_sub_control.controller
			else if classof OBJ.controller == IKChainControl then xformC = OBJ.controller.IK_goal.controller
				else xformC = OBJ.controller
		
		if classof xformC == IK_ControllerMatrix3Controller do
		(	if (substring (Trans as string) 1 3) as name == #pos then Trans = getsubanimname xformC 1
			else if (substring (Trans as string) 1 3) as name == #rot then Trans = getsubanimname xformC 2
		)

		if classof xformC == Link_Constraint do xformC = xformC.link_params
		if classof xformC == Link_Transform do xformC = xformC.Scene_Transform
		
		local newC = execute (constraint as string + "()")
		If List == True then
		(	local oldC = getPropertyController xformC  trans
			if classof oldC != ListType then
			(
				if(IsLayerControl oldC) then
				(
					oldc = oldC[oldC.active].controller 
			 
				)
			)
			oldC.available.controller = newC
		)
		Else 
			if (setPropertyController xformC trans newC) == undefined do throw 0
		newC
	)
	Catch (MessageBox ~MSGBOX_CONSTRAINT_ERROR~ Title:~MSGBOX_CONTROLLER_FUNCTIONS_TITLE~;throw())
)

fn SetActiveController Controller subController =
(
	Try
	(	local index
		for i = 1 to (Controller.numsubs-1) do
			if controller[i].controller == subController do index = i
		if index != undefined do
		(	listCtrl.setActive controller index
			format ~FORMAT_SETTING_AS_ACTIVE_CONTROLLER~ (listCtrl.getName controller index)
		)
	)
	Catch ( MessageBox ~MSGBOX_SET_ACTIVE_CONTROLLER_ERROR~ Title:~MSGBOX_SET_ACTIVE_CONTROLLER_TITLE~)
)


-------------------------------------------------------------------------------------------
-- ShapeFilterFn
-- This function used in PickObject for path validates that the node is a shape
-- and that it's not dependent on the selection
-------------------------------------------------------------------------------------------
fn ShapeFilterFn obj = 
(
	valid = true
	if superClassOf obj != Shape then
		valid = false
	else
	(
		valid = false
		for node in selection while not valid DO
		(
			if (refs.DependencyLoopTest obj node.controller) != true then
			(
				valid = true
			)
		)
	)
	valid
)
		
-------------------------------------------------------------------------------------------
-- SurfaceFilterFn
-- This function used in PickObject for Surface constraint validates that the node is 
-- a surface and is not dependent on the selection
-------------------------------------------------------------------------------------------
fn SurfaceFilterFn obj = 
(
	valid = true
	objClass = ClassOf obj
	if (objClass != NURBSSurf and
	    objClass != Editable_Patch and
	    objClass != Sphere and
	    objClass != Cone and
	    objClass != Cylinder and
	    objClass != Torus and
	    objClass != Loft) then
		valid = false
	else
	(
		valid = false
		for node in selection while not valid DO
		(
			if (refs.DependencyLoopTest obj node.controller) != true then
			(
				valid = true
			)
		)
	)
	valid
)
				
-------------------------------------------------------------------------------------------
-- GeomFilterFn
-- This function used in PickObject for Attachment constraint validates that the node is 
-- a geometry and is not dependent on the selection
-------------------------------------------------------------------------------------------
fn GeomFilterFn obj = 
(
	valid = true
	if superClassOf obj != GeometryClass then
		valid = false
	else
	(
		valid = false
		for node in selection while not valid DO
		(
			if (refs.DependencyLoopTest obj node.controller) != true then
			(
				valid = true
			)
		)
	)
	valid
)
			
-------------------------------------------------------------------------------------------
-- ConstrFilterFn
-- This function used in PickObject for some constraints validates that the node is not
-- dependent on the selection
-------------------------------------------------------------------------------------------
fn ConstrFilterFn obj = 
(
	valid = false
	for node in selection while not valid DO
	(
		if (refs.DependencyLoopTest obj node.controller) != true then
		(
			valid = true
		)
	)
	valid
)
	
			
--------------------------------------------------------------------------------
--  IsValidControllerSelection 

-- function returning true if there is at least one node selected that can be 
-- assigned a controller, i.e. not a biped slave, not an xref controller or 
-- not a Matrix3 controller.  If more than 200 nodes are selected, then
-- in order to accelerate the validation it is assumed that the selection is 
-- valid.
--------------------------------------------------------------------------------
fn IsValidControllerSelection = 
(
	local isValid = false;
	if selection.count > 200 then isValid = true
	else
	(
		for node in selection while not isValid do
		(
			local controllerClass = classof node.controller
			if (controllerClass != BipSlave_Control and \
				controllerClass != XRef_Controller and \
			    (controllerClass != IK_ControllerMatrix3Controller or \
				 node.controller[1].controller != undefined)) then isValid = true
		)
	)
	isValid
)


--------------------------------------------------------------------------------
--  AssignControllerSelection 

-- function assigning a controller to all selected nodes
--------------------------------------------------------------------------------
fn AssignControllerSelection CONTROLLER_TYPE Trans ListType MsgBoxBody = 
(
	Try
	(
		-------------------------------------------------------------------------------------------
		-- Switch to Motion Panel
		-------------------------------------------------------------------------------------------
	
		IF selection.count == 1 AND getCommandPanelTaskMode() != #motion then SetCommandPanelTaskMode Mode:#Motion
		
		for node in selection do
		(
			local controllerClass = classof node.controller
			if not (controllerClass == BipSlave_Control or
				    controllerClass == XRef_Controller or
				    (controllerClass == IK_ControllerMatrix3Controller and 
				     node.controller[1].controller == undefined)) then
			(
				-------------------------------------------------------------------------------------------
				-- Skip group members, only apply to head
				-------------------------------------------------------------------------------------------
				local h = node.parent 
				if not (h != undefined and h.isSelected and isGroupHead h) then
				(
					-------------------------------------------------------------------------------------------
					-- Add List Controller
					-------------------------------------------------------------------------------------------
					
					local cont = AddListController node Trans ListType 
					
					-------------------------------------------------------------------------------------------
					-- Add Constraint
					---------------------------------------------------------------------------------------
					If classof cont[listCtrl.GetActive cont].object != CONTROLLER_TYPE then 
					(
						controller = AddConstraint node Trans CONTROLLER_TYPE true
					)
					else 
					(
						controller = cont[listCtrl.GetActive cont].object
					)
			
					-------------------------------------------------------------------------------------------
					-- Set Active Controller
					-------------------------------------------------------------------------------------------
							
					SetActiveController cont controller
					
					-- the script used to select the selected node here, but I don't see why, and 
					-- it would now break the loop on selected nodes
				)
			)
		)
			
	)
	Catch (MessageBox MsgBoxBody Title:~MSGBOX_CONTROLLERS_TITLE~)
)


--------------------------------------------------------------------------------
--  AssignConstraintSelection 

-- function assigning a constraint to all selected nodes
--------------------------------------------------------------------------------
fn AssignConstraintSelection CONSTRAINT_TYPE Trans ListType FiltFn PickMsg MsgBoxBody = 
(
	Try
	(
		-------------------------------------------------------------------------------------------
		-- Switch to Motion Panel
		-------------------------------------------------------------------------------------------
	
		IF selection.count == 1 AND getCommandPanelTaskMode() != #motion then SetCommandPanelTaskMode Mode:#Motion
		
		-------------------------------------------------------------------------------------------
				
		EC_TargetOBJ = PickObject count:1 filter:FiltFn message:PickMsg Rubberband:selection[1].transform.pos ForceListenerFocus:False
		if EC_TargetOBJ != undefined and EC_TargetOBJ != "None" then
		(
			for node in selection do
			(
				local controllerClass = classof node.controller
				if not (controllerClass == BipSlave_Control or
						controllerClass == XRef_Controller or
						(controllerClass == IK_ControllerMatrix3Controller and 
						 node.controller[1].controller == undefined)) then
				(
					-------------------------------------------------------------------------------------------
					-- Skip group members, only apply to head
					-------------------------------------------------------------------------------------------
					local h = node.parent 
					if not (h != undefined and h.isSelected and isGroupHead h) then
					(
						if (refs.DependencyLoopTest EC_TargetOBJ node.controller != true) then
						(
							-------------------------------------------------------------------------------------------
							-- Add List Controller
							-------------------------------------------------------------------------------------------
							
							local cont = AddListController node Trans ListType 
							
							-------------------------------------------------------------------------------------------
							-- Add Constraint
							---------------------------------------------------------------------------------------
							If classof cont[listCtrl.GetActive cont].object != CONSTRAINT_TYPE then 
							(
								constraint = AddConstraint node Trans CONSTRAINT_TYPE true
							)
							else 
							(
								constraint = cont[listCtrl.GetActive cont].object
							)
					
							-------------------------------------------------------------------------------------------
							-- Add Constraint Objects
							-------------------------------------------------------------------------------------------
									
							if ((constraint.AppendTarget EC_TargetOBJ 50) == true) then
							(
								-------------------------------------------------------------------------------------------
								-- Set Active Controller
								-------------------------------------------------------------------------------------------
										
								SetActiveController cont constraint
											
								--Format "%\n"  (node.name + " is Constrained to " + EC_TargetOBJ.name) to:Listener
							)
							else throw 0
						)
					)
				)
			)
		)			
	)
	Catch (MessageBox MsgBoxBody Title:~MSGBOX_CONSTRAINTS_TITLE~)
)



-------BEGIN-SIGNATURE-----
-- 4wYAADCCBt8GCSqGSIb3DQEHAqCCBtAwggbMAgEBMQ8wDQYJKoZIhvcNAQELBQAw
-- CwYJKoZIhvcNAQcBoIIE3jCCBNowggPCoAMCAQICEDUAFkMQxqI9PltZ2eUG16Ew
-- DQYJKoZIhvcNAQELBQAwgYQxCzAJBgNVBAYTAlVTMR0wGwYDVQQKExRTeW1hbnRl
-- YyBDb3Jwb3JhdGlvbjEfMB0GA1UECxMWU3ltYW50ZWMgVHJ1c3QgTmV0d29yazE1
-- MDMGA1UEAxMsU3ltYW50ZWMgQ2xhc3MgMyBTSEEyNTYgQ29kZSBTaWduaW5nIENB
-- IC0gRzIwHhcNMTkwNjI1MDAwMDAwWhcNMjAwODA3MjM1OTU5WjCBijELMAkGA1UE
-- BhMCVVMxEzARBgNVBAgMCkNhbGlmb3JuaWExEzARBgNVBAcMClNhbiBSYWZhZWwx
-- FzAVBgNVBAoMDkF1dG9kZXNrLCBJbmMuMR8wHQYDVQQLDBZEZXNpZ24gU29sdXRp
-- b25zIEdyb3VwMRcwFQYDVQQDDA5BdXRvZGVzaywgSW5jLjCCASIwDQYJKoZIhvcN
-- AQEBBQADggEPADCCAQoCggEBAMsptjSEm+HPve6+DClr+K4CgrtrONjtHxHBwTMC
-- mrwF9bnsdMiSgvYigTKk858TlqVs7GiBVLD3SaSZqfSXOv7L55i965L+wIx0EZxX
-- xDzbyLh1rLSSNWO8oTDIKnPsiwo5x7CHRUi/eAICOvLmz7Rzi+becd1j/JPNWe5t
-- vum0GL/8G4vYICrhCycizGIuv3QFqv0YPM75Pd2NP0V4W87XPeTrj+qQoRKMztJ4
-- WNDgLgT4LbMBIZyluU8iwXNyWQ8FC2ya3iJyy0EhZhAB2H7oMrAcV1VJJqwZcZQU
-- XMJTD+tuCqKqJ1ftv1f0JVW2AADnHgvaB6E6Y9yR/jnn4zECAwEAAaOCAT4wggE6
-- MAkGA1UdEwQCMAAwDgYDVR0PAQH/BAQDAgeAMBMGA1UdJQQMMAoGCCsGAQUFBwMD
-- MGEGA1UdIARaMFgwVgYGZ4EMAQQBMEwwIwYIKwYBBQUHAgEWF2h0dHBzOi8vZC5z
-- eW1jYi5jb20vY3BzMCUGCCsGAQUFBwICMBkMF2h0dHBzOi8vZC5zeW1jYi5jb20v
-- cnBhMB8GA1UdIwQYMBaAFNTABiJJ6zlL3ZPiXKG4R3YJcgNYMCsGA1UdHwQkMCIw
-- IKAeoByGGmh0dHA6Ly9yYi5zeW1jYi5jb20vcmIuY3JsMFcGCCsGAQUFBwEBBEsw
-- STAfBggrBgEFBQcwAYYTaHR0cDovL3JiLnN5bWNkLmNvbTAmBggrBgEFBQcwAoYa
-- aHR0cDovL3JiLnN5bWNiLmNvbS9yYi5jcnQwDQYJKoZIhvcNAQELBQADggEBADo7
-- 6cASiVbzkjsADk5MsC3++cj9EjWeiuq+zzKbe55p6jBNphsqLUvMw+Z9r2MpxTEs
-- c//MNUXidFsslWvWAUeOdtytNfhdyXfENX3baBPWHhW1zvbOPHQLyz8LmR1bNe9f
-- R1SLAezJaGzeuaY/Cog32Jh4qDyLSzx87tRUJI2Ro5BLA5+ELiY21SDZ7CP9ptbU
-- CDROdHY5jk/WeNh+3gLHeikJSM9/FPszQwVc9mjbVEW0PSl1cCLYEXu4T0o09ejX
-- NaQPg10POH7FequNcKw50L63feYRStDf6GlO4kNXKFHIy+LPdLaSdCQL2/oi3edV
-- MdpL4F7yw1zQBzShYMoxggHFMIIBwQIBATCBmTCBhDELMAkGA1UEBhMCVVMxHTAb
-- BgNVBAoTFFN5bWFudGVjIENvcnBvcmF0aW9uMR8wHQYDVQQLExZTeW1hbnRlYyBU
-- cnVzdCBOZXR3b3JrMTUwMwYDVQQDEyxTeW1hbnRlYyBDbGFzcyAzIFNIQTI1NiBD
-- b2RlIFNpZ25pbmcgQ0EgLSBHMgIQNQAWQxDGoj0+W1nZ5QbXoTANBgkqhkiG9w0B
-- AQsFADANBgkqhkiG9w0BAQEFAASCAQBGJO9eYi97bTt3Bk5Rc+2SruoY1VuqMvVn
-- Wzq2s65fY8G5q4UssnWeF3BafI7Jmnr1J0zOGa8Dt9oLFgJ2PhLoB05AtrPDr8Or
-- 2Sf6kCzI8rskKP02olSEW1Gw52axji2PsRuybgG5NTOnv9420wuoxZ8vbVcAs27D
-- xPrG6NVI4VeFgIc5L7aTLvIlBMmPuKp4WnQ2mDDZ53LhMQp5GBL5rvw9CumVK8n6
-- 1NDtko8rzITjTiQJAg3TlvYNXh7udvuyxNVN1EX31A8DMqdBD+8ZgxI4g4j7+9dv
-- BBnGduoqz7XTQxgPhhdoUGmsbVAc2gM7m/BNtbM6TOZ7+S8HRc56
-- -----END-SIGNATURE-----